/**
* \file: GstreamerCommon.h
*
* \version: $Id:$
*
* \release: $Name:$
*
* <brief description>.
* <detailed description>
* \component: Digital iPod Out
*
* \author: Veeraiyan Chidambaram /RBEI/ECF3/ veeraiyan.chidambaram@in.bosch.com
*          J. Harder / ADIT/SW1 / jharder@de.adit-jv.com
*
* \copyright (c) 2013 Advanced Driver Information Technology.
* This code is developed by Advanced Driver Information Technology.
* Copyright of Advanced Driver Information Technology, Bosch, and DENSO.
* All rights reserved.
*
* \see <related items>
*
* \history
*
***********************************************************************/

#ifndef CARPLAY_GSTREAMERCOMMON_H
#define CARPLAY_GSTREAMERCOMMON_H

#include <atomic>
#include <mutex>
#include <gst/gst.h>
#include <carplay_plugin.h>
#include <dipo_macros.h>
#include <adit_logging.h>

#include <time.h>
#include <sys/prctl.h>

namespace adit { namespace carplay
{

const uint64_t NS_TO_MS = 1000 * 1000;
const uint64_t MS_TO_S = 1000;

const uint64_t OUT_BUS_STOP_DEFAULT_MILLI = 500;
const uint64_t ONE_MILLI_IN_NANO = 1000 * 1000;
const uint64_t ONE_SEC_IN_NANO = 1000 * 1000 * 1000;

enum GstreamerChannelNames
{
    GstreamerChannelName_Invalid = 0,
    GstreamerChannelName_VideoOut = 1,
    GstreamerChannelName_MainAudioOut = 2,
    GstreamerChannelName_AlternateAudioOut = 3,
    GstreamerChannelName_MainAudioIn = 4,
};

extern const char* GstreamerChannelNameStrings[];

uint64_t GetHostTicks();
uint64_t GetTickDifference(uint64_t inFirst, uint64_t inSecond);

void MessageBusAddRef(int threadPrio);
void MessageBusUnref();

#define GST_MAIN_LOOP_PRIO    19
class GstreamerCommon
{
public:
    GstBus* bus;
    GstElement* pipeline;
    GstElement* partial;
    GstreamerChannelNames channelName;
    guint watchId;

    GstreamerCommon();
    ~GstreamerCommon();

    bool CreatePipeline(const std::string& inName, const std::string& inLaunch,
            GstreamerChannelNames inChannelName);
    void StopPipeline();
    int SetThreadPriority(const char* threadName, uint32_t priority);
};

gboolean busCallBack(GstBus* inBus, GstMessage* inMessage, gpointer inPointer);
uint64_t gstToNTP64(uint64_t inGstTs);
GstCaps* createCapsFromAudioFormat(AudioFormatStruct inFormat);

} } /* namespace adit { namespace carplay */

#endif /* CARPLAY_GSTREAMERCOMMON_H */
